<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LiveFile extends Model
{
    use HasFactory;

    protected $table = 'live_files';

    protected $fillable = [
        'session_id',
        'uploader_id',
        'file_path',
        'file_name',
        'uploaded_at',
    ];

    public $timestamps = false;

    public function uploader()
    {
        return $this->belongsTo(User::class, 'uploader_id');
    }

    public function session()
    {
        return $this->belongsTo(LiveSession::class, 'session_id');
    }
}
