<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    protected $fillable = ['name', 'description'];

    public function users()
    {
        return $this->belongsToMany(User::class)->withPivot('role')->withTimestamps();
    }

    public function sessions()
    {
        return $this->hasMany(LiveSession::class);
    }

    public function teacher()
{
    return $this->belongsTo(User::class, 'teacher_id');
}
}
