<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Goal extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'title',
        'description',   // ✅ ajouté
        'notes',         // ✅ ajouté
        'checklist',     // ✅ ajouté (JSON)
        'comment',       // ✅ ajouté
        'status',
        'priority',
        'task_type',
        'due_date',
        'label',
        'position'
    ];

    // Relation avec User
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Scope pour récupérer par statut
    public function scopeByStatus($query, $status)
    {
        return $query->where('status', $status)->orderBy('position');
    }

    public function subtasks()
    {
        return $this->hasMany(GoalSubtask::class);
    }
}
