<?php

namespace App\Http\Controllers\Teacher;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Group;
use App\Models\User;


class Teachergroupeandclasse extends Controller
{
    public function index()
    {
        $teacher = auth()->user();

        // Récupérer uniquement les groupes qui appartiennent au professeur connecté
        $groups = Group::where('teacher_id', $teacher->id)->get();

        return view('teacher.groups.index', compact('groups'));
    }

    public function studentDetail($id)
{
    $teacher = auth()->user();

    // Vérifier que l'étudiant existe
    $student = User::findOrFail($id);

    // Vérifier que l'étudiant appartient à un groupe du professeur
   $isInTeacherGroup = $teacher->groups()
    ->whereHas('users', function ($query) use ($id) {
        $query->where('group_user.user_id', $id)
              ->where('group_user.role', 'student');
    })
    ->exists();

    if (!$isInTeacherGroup) {
        abort(403, "Vous n'avez pas accès à cet étudiant.");
    }

    return view('teacher.student-detail', compact('student'));
}
}
