<?php

namespace App\Http\Controllers\Teacher;

use App\Http\Controllers\Controller;
use App\Models\Meeting;
use App\Models\Goal;
use App\Models\Group;
use Illuminate\Support\Facades\Auth;

class TeacherDashboardController extends Controller
{
    public function index()
    {
        $teacherId = Auth::id();

        // ---------------------------
        // 📌 1. Statistiques
        // ---------------------------
        $stats = [
            'total_revenue' => '10.950 DT',
            'month_revenue' => '1450 DT',
            'teaching_hours' => '250',
            'balance' => '8550 DT',
        ];

        // ---------------------------
        // 📌 2. Upcoming Sessions
        // ---------------------------
        $upcomingSessions = Meeting::where('user_id', $teacherId)
            ->where('start_time', '>=', now())
            ->orderBy('start_time', 'asc')
            ->limit(5)
            ->get();

        // ---------------------------
        // 📌 3. Urgent Goals (status = in_progress ou pending)
        // ---------------------------
        $urgentGoals = Goal::where('user_id', $teacherId)
            ->whereIn('priority', ['high', 'urgent'])
            ->orderBy('due_date', 'asc')
            ->limit(5)
            ->get();

        // ---------------------------
        // 📌 4. Groups du teacher
        // ---------------------------
        $userGroups = Group::whereHas('users', function ($query) use ($teacherId) {
                $query->where('user_id', $teacherId);
            })
            ->with(['users'])
            ->get();

        $groupsCount = $userGroups->count();

        // ---------------------------
        // 📌 5. Return View
        // ---------------------------
        return view('teacher.dashboard', compact(
            'stats',
            'upcomingSessions',
            'urgentGoals',
            'userGroups',
            'groupsCount'
        ));
    }
}
