<?php

namespace App\Http\Controllers\Student;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;

class VideoSDKController extends Controller
{
    public function index()
    {
        return view('student.videosdk.index');
    }

public function createRoom(Request $request)
{
    $apiKey = env('VIDEOSDK_API_KEY');
    $secret = env('VIDEOSDK_SECRET_KEY');

    // ✅ Générer un JWT conforme
    $payload = [
        "apikey" => $apiKey,
        "permissions" => [
            "allow_join",            // Autorise l'utilisateur à rejoindre
            "allow_mod",             // Autorise l'utilisateur à modérer
            "allow_create",          // Autorise la création de salle
            "allow_recording",       // (facultatif)
            "allow_streaming"        // (facultatif)
        ],
        "version" => 2,              // 👈 très important : version du token
        "iat" => time(),
        "exp" => time() + (60 * 60),
    ];

    $token = JWT::encode($payload, $secret, 'HS256');

    Log::info('🎥 [VideoSDK] Token généré localement', ['token' => $token]);

    // ✅ Créer la salle avec ce token
    $response = Http::withHeaders([
        'Authorization' => $token,
        'Content-Type' => 'application/json',
    ])->post('https://api.videosdk.live/v2/rooms', [
        'region' => env('VIDEOSDK_REGION', 'sg001'),
    ]);

    Log::info('🎥 [VideoSDK] Réponse création room', [
        'status' => $response->status(),
        'body' => $response->body(),
    ]);

    if ($response->failed()) {
        Log::error('❌ [VideoSDK] Erreur lors de la création de la salle', [
            'body' => $response->body(),
        ]);
        return back()->with('error', 'Erreur VideoSDK: ' . $response->body());
    }

    $roomId = $response->json()['roomId'] ?? null;

    if (!$roomId) {
        Log::error('❌ [VideoSDK] Aucun roomId retourné', ['body' => $response->body()]);
        return back()->with('error', 'Aucun roomId retourné.');
    }

    Log::info('✅ [VideoSDK] Salle créée avec succès', ['roomId' => $roomId]);

    return redirect()->route('student.videosdk.room', $roomId);
}
public function joinRoom($roomId)
{
    $apiKey = env('VIDEOSDK_API_KEY');
    $secret = env('VIDEOSDK_SECRET_KEY');
    $user = Auth::user();

    $payload = [
        "apikey" => $apiKey,
        "permissions" => ["allow_join"],
        "version" => 2,
        "iat" => time(),
        "exp" => time() + (60 * 60),
    ];

    $token = \Firebase\JWT\JWT::encode($payload, $secret, 'HS256');

    return view('student.videosdk.room', compact('roomId', 'token', 'user'));
}

}
