<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use App\Services\LiveKitService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class LiveKitController extends Controller
{
    public function index()
    {
        return view('student.livekit.index');
    }

    public function createRoom(Request $request, LiveKitService $livekit)
    {
        $request->validate(['topic' => 'required|string|max:255']);
        $roomName = Str::slug($request->topic) . '-' . Str::random(6);
        $token = $livekit->generateToken($roomName, Auth::user()->name);

        return redirect()->route('student.livekit.room', ['room' => $roomName, 'token' => $token]);
    }

    public function joinRoom($room)
    {
        $token = app(LiveKitService::class)->generateToken($room, Auth::user()->name);
        return view('student.livekit.room', compact('room', 'token'));
    }
}
