<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\JitsiMeeting;
use Illuminate\Support\Facades\Auth;

class JitsiController extends Controller
{
    /**
     * Liste des réunions Jitsi disponibles.
     */
    public function index()
    {
        $meetings = JitsiMeeting::latest()->get();
        return view('student.jitsi.index', compact('meetings'));
    }

    /**
     * Crée une nouvelle réunion Jitsi (enseignant uniquement)
     */
    public function store(Request $request)
{
    $request->validate([
        'topic' => 'required|string|max:255',
    ]);

    $meeting = JitsiMeeting::create([
        'teacher_id' => Auth::id(), // Peu importe si c’est un étudiant ou prof
        'topic' => $request->topic,
        'room_code' => 'class-' . Str::random(10),
    ]);

    return redirect()->route('student.jitsi.show', $meeting->room_code);
}

    /**
     * Affiche la réunion dans le site (visioconférence intégrée)
     */
    public function show($room_code)
    {
        $meeting = JitsiMeeting::where('room_code', $room_code)->firstOrFail();
        $user = Auth::user();
        return view('student.jitsi.show', compact('meeting', 'user'));
    }
}
