<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Feedback;
use Illuminate\Support\Facades\Auth;

class FeedbackController extends Controller
{
    public function index()
    {
        $feedbacks = Feedback::where('user_id', Auth::id())->latest()->get();
        return view('student.feedback', compact('feedbacks'));
    }

   public function store(Request $request)
{
    $request->validate([
        'type' => 'required|in:idea,experience,bug,teacher',
        'message' => 'required|string|max:2000',
        'category' => 'nullable|string|max:255',
        'suggestion' => 'nullable|string|max:255',
    ]);

    Feedback::create([
        'user_id' => Auth::id(),
        'type' => $request->type,
        'category' => $request->category,
        'suggestion' => $request->suggestion,
        'message' => $request->message,
    ]);

    return redirect()->back()->with('success', 'Thank you for your feedback. ');
}

}
