<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EmailVerificationController extends Controller
{
    /**
     * Enregistre un code de vérification dans la base
     */
   public function sendVerificationCode(Request $request)
{
    $user = Auth::user();

    $code = rand(100000, 999999);
    $user->verification_code = $code;
    $user->save();

    // On stocke un indicateur en session
    return redirect()->back()->with('open_code_modal', true);
}

    /**
     * Vérifie le code et met à jour l'email
     */
  public function confirmCode(Request $request)
{
    $request->validate([
        'code' => 'required|numeric',
        'new_email' => 'required|email|unique:users,email',
    ]);

    $user = Auth::user();

    if ($user->verification_code != $request->code) {
        // ⚠️ Code incorrect
        return redirect()->back()->with('error', 'Invalid or expired verification code ❌');
    }

    // ✅ Code correct → mise à jour de l'email
    $user->update([
        'email' => $request->new_email,
        'verification_code' => null,
    ]);

    return redirect()->back()->with('success', 'Email updated successfully ✅');
}
}
