<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();

        // Statistiques des tâches
        $totalTasks = DB::table('student_tasks')
            ->where('user_id', $user->id)
            ->count();

        $completedTasks = DB::table('student_tasks')
            ->where('user_id', $user->id)
            ->where('completed', 1)
            ->count();

        $pendingTasks = $totalTasks - $completedTasks;

        $taskProgress = $totalTasks > 0 ? round(($completedTasks / $totalTasks) * 100) : 0;

        // Statistiques des objectifs (goals)
        $totalGoals = DB::table('goals')
            ->where('user_id', $user->id)
            ->count();

        $goalsCompleted = DB::table('goals')
            ->where('user_id', $user->id)
            ->where('status', 'done')
            ->count();

        $goalsInProgress = DB::table('goals')
            ->where('user_id', $user->id)
            ->where('status', 'in_progress')
            ->count();

        $goalsNotStarted = DB::table('goals')
            ->where('user_id', $user->id)
            ->where('status', 'not_started')
            ->count();

        // Groupes de l'étudiant
        $userGroups = DB::table('group_user')
            ->join('groups', 'group_user.group_id', '=', 'groups.id')
            ->where('group_user.user_id', $user->id)
            ->select('groups.*', 'group_user.role')
            ->get();

        $groupsCount = $userGroups->count();

        // Sessions à venir (Live Sessions)
       $upcomingSessions = DB::table('meetings')
    ->join('group_user', 'meetings.group_id', '=', 'group_user.group_id')
    ->where('group_user.user_id', $user->id)
    ->where('meetings.start_time', '>=', Carbon::now()) // seulement les futures
    ->orderBy('meetings.start_time', 'asc')
    ->limit(5)
    ->select('meetings.*')
    ->get();

        // Projets de l'étudiant
        $projects = DB::table('projects')
            ->where('user_id', $user->id)
            ->orderBy('created_at', 'desc')
            ->limit(5)
            ->get();

        $projectsCount = DB::table('projects')
            ->where('user_id', $user->id)
            ->count();

        // Conversations Nova récentes
        $recentConversations = DB::table('nova_conversations')
            ->where('user_id', $user->id)
            ->orderBy('last_message_at', 'desc')
            ->limit(3)
            ->get();

        // Tâches récentes (à faire aujourd'hui)
        $todayTasks = DB::table('student_tasks')
            ->where('user_id', $user->id)
            ->where('completed', 0)
            ->orderBy('created_at', 'desc')
            ->limit(5)
            ->get();

        // Objectifs urgents (échéance proche)
        $urgentGoals = DB::table('goals')
            ->where('user_id', $user->id)
            ->where('status', '!=', 'done')
            ->where('priority', 'high')
            ->orderBy('due_date', 'asc')
            ->limit(5)
            ->get();

        // Statistiques d'activité (derniers 7 jours)
        $recentActivity = [
            'tasks_completed' => DB::table('student_tasks')
                ->where('user_id', $user->id)
                ->where('completed', 1)
                ->where('updated_at', '>=', Carbon::now()->subDays(7))
                ->count(),
            'goals_completed' => DB::table('goals')
                ->where('user_id', $user->id)
                ->where('status', 'done')
                ->where('updated_at', '>=', Carbon::now()->subDays(7))
                ->count(),
            'nova_conversations' => DB::table('nova_conversations')
                ->where('user_id', $user->id)
                ->where('created_at', '>=', Carbon::now()->subDays(7))
                ->count(),
        ];

        // Points (tu peux adapter selon ton système de points)
        $points = 1599; // À adapter selon ta logique

        return view('student.dashboard', compact(
            'points',
            'totalTasks',
            'completedTasks',
            'pendingTasks',
            'taskProgress',
            'totalGoals',
            'goalsCompleted',
            'goalsInProgress',
            'goalsNotStarted',
            'userGroups',
            'groupsCount',
            'upcomingSessions',
            'projects',
            'projectsCount',
            'recentConversations',
            'todayTasks',
            'urgentGoals',
            'recentActivity'
        ));
    }
}
