<?php

namespace App\Http\Controllers;

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    // Afficher la page de login
    public function showLoginForm()
    {
        return view('auth.login');
    }

    // Traiter la connexion
    public function login(Request $request)
    {
        $credentials = [
            'email' => $request->input('login_data'),
            'password' => $request->input('password'),
        ];

        if (Auth::attempt($credentials, $request->has('remember_me'))) {
            $user = Auth::user();


            switch ($user->role) {
                case 'admin':
                    return redirect()->route('admin.dashboard');
                case 'teacher':
                    return redirect()->route('teacher.dashboard');
                case 'student':
                    return redirect()->route('student.dashboard');
                case 'affiliate':
                    return redirect()->route('affiliate.dashboard');
                default:
                    return redirect()->route('dashboard');
            }
        }

        return back()->with('error', 'Email ou mot de passe incorrect.');
    }

    // Déconnexion
    public function logout()
    {
        Auth::logout();
        return redirect()->route('login')->with('success', 'Déconnecté avec succès.');
    }

    public function showRegisterForm()
{
    return view('auth.register');
}

public function register(Request $request)
{
    // ✅ Validation du formulaire
    $request->validate([
        'name' => 'required|string|max:255',
        'username' => 'required|string|max:100|unique:users,username',
        'email' => 'required|email|max:255|unique:users,email',
        'phone' => 'required|string|max:20|unique:users,phone',
        'password' => 'required|confirmed|min:6',
        'terms_condition' => 'accepted',
    ], [
        'terms_condition.accepted' => 'Vous devez accepter les conditions d’utilisation.'
    ]);

    // ✅ Création de l’utilisateur
    $user = User::create([
        'name' => $request->name,
        'email' => $request->email,
        'username' => $request->username,
        'phone' => $request->phone,
        'password' => Hash::make($request->password),
        'role' => 'student', // 🔹 par défaut tout nouvel inscrit est un étudiant
    ]);

    // ✅ Connexion automatique
    Auth::login($user);

    // ✅ Redirection vers son tableau de bord
    return redirect()->route('student.dashboard')->with('success', 'Inscription réussie, bienvenue !');
}
}
