<?php

namespace App\Events;

use App\Models\LiveMessage;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class MessageSent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $user;
    public $message;
    public $session_id;

    /**
     * Crée une nouvelle instance de l'événement
     */
    public function __construct(LiveMessage $message)
    {
        $this->user = $message->sender;
        $this->message = $message->message;
        $this->session_id = $message->session_id;
    }

    /**
     * Canal de diffusion
     */
    public function broadcastOn()
    {
        // Chaque live a son propre canal
        return new Channel('live.' . $this->session_id);
    }

    /**
     * Nom de l'événement côté client (Echo)
     */
    public function broadcastAs()
    {
        return 'MessageSent';
    }
}
